#include <stdio.h>
#include <stdlib.h>

#include "hdf5.h"

int main(void)
{
herr_t ier;
unsigned maj, min, rel;

ier = H5open();
if (ier) {
    fprintf(stderr,"Unable to initialize HDF5: %d\n", ier);
    return EXIT_FAILURE;
}

ier = H5get_libversion(&maj, &min, &rel);
if (ier) {
    fprintf(stderr,"HDF5 did not initialize!\n");
    return EXIT_FAILURE;
}
printf("C HDF5 version %d.%d.%d\n", maj, min, rel);

ier = H5close();
if (ier) {
    fprintf(stderr,"Unable to close HDF5: %d\n", ier);
    return EXIT_FAILURE;
}
return EXIT_SUCCESS;
}
